const Threshold = 500;

document.addEventListener("contextmenu", (event) => event.preventDefault());

document.querySelectorAll(".btn").forEach((element) => {
  const output = document.querySelector(`#output${element.id}`);
  const count = document.querySelector(`#clickCount${element.id}`);
  let sequence = [];

  let counter = 0;
  let prevEvent = 0;

  function sequenceHandler(eventName) {
    element.addEventListener(eventName, (event) => {
      if (event.timeStamp - prevEvent > Threshold) {
        sequence = [];
      }

      prevEvent = event.timeStamp;

      sequence.push(eventName);
      output.innerHTML = sequence.join(", ");
    });
  }

  sequenceHandler("pointerdown");
  sequenceHandler("mousedown");
  sequenceHandler("pointercancel");
  sequenceHandler("pointerup");
  sequenceHandler("mouseup");
  sequenceHandler("click");

  element.addEventListener("click", (event) => {
    counter += 1;
    count.innerHTML = counter;
  });
});
